/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.mccs;

import com.quantumdata.mccs.MCCSGUIFrame;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.StdConnectionManager;
import java.awt.Component;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class MCCSGUI
extends JApplet {
    private static final long serialVersionUID = 2L;
    public static MCCSGUIFrame theApp;
    public static MCCSGUI startUpApp;

    public static void main(String[] stringArray) {
        startUpApp = new MCCSGUI();
        startUpApp.init();
    }

    public void init() {
        theApp = new MCCSGUIFrame();
        if (startUpApp != null) {
            theApp.setDefaultCloseOperation(3);
        }
        MCCSGUI.init(theApp, this);
    }

    public void stop() {
        if (theApp != null) {
            theApp.disconnect();
        }
        super.stop();
    }

    private static void init(MCCSGUIFrame mCCSGUIFrame, Component component) {
        try {
            UIManager.setLookAndFeel("com.quantumdata.laf.QDILookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        StdConnectionManager stdConnectionManager = new StdConnectionManager(component);
        mCCSGUIFrame.setInstrument(MCCSGUI.setInstrument(stdConnectionManager));
        if (!mCCSGUIFrame.isSupportedUnit()) {
            JOptionPane.showMessageDialog(mCCSGUIFrame, "Sorry, this feature is not available on 881-series units.", "Unsupported Feature Error", 0);
            if (theApp != null) {
                theApp.disconnect();
            }
            return;
        }
        Object[] objectArray = new Object[]{"Query then launch the GUI", "NO query, launch GUI now"};
        int n = JOptionPane.showOptionDialog(null, "System is going to query MCCS capability first from the connected display device!\nIt may take up to several minutes\n\nDo you want to:", "Query Capability?", 0, 3, null, objectArray, objectArray[0]);
        mCCSGUIFrame.init(n == 0);
    }

    public static RemoteInstrument setInstrument(StdConnectionManager stdConnectionManager) {
        RemoteInstrument remoteInstrument = stdConnectionManager.newConnection();
        try {
            remoteInstrument.connect();
        }
        catch (InstrumentException instrumentException) {
            JOptionPane.showMessageDialog(new JPanel(), "*** CONNECTION FAILED: " + instrumentException.getMessage() + " ***");
            System.exit(0);
        }
        return remoteInstrument;
    }
}

